<?php

namespace App\Http\Controllers;

use App\Models\OnlineVideoAttendance;
use Illuminate\Http\Request;

use App\Http\Requests\StoreOnlineAttendanceRequest;
//use App\http\Requests\AcademicYear\UpdateRequest;

use Carbon\Carbon;

class OnlineVideoAttendanceReportController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if(isset($request->student_id)){
            $response['data'] = OnlineVideoAttendance::where('student_id', $request->student_id)->orderBy('created_at', 'desc')->paginate(15);
            $response['status'] = 200;
            return response()->json($response);
        } 
        else{
            $response['status'] = 202;
            $response['message'] = 'Student Details not found';
            return response()->json($response);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreOnlineAttendanceRequest $request) {
        //
           }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\OnlineVideoAttendance  $onlineVideoAttendance
     * @return \Illuminate\Http\Response
     */
    public function show(OnlineVideoAttendance $onlineVideoAttendance)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\OnlineVideoAttendance  $onlineVideoAttendance
     * @return \Illuminate\Http\Response
     */
    public function edit(OnlineVideoAttendance $onlineVideoAttendance)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\OnlineVideoAttendance  $onlineVideoAttendance
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {
    //
        
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\OnlineVideoAttendance  $onlineVideoAttendance
     * @return \Illuminate\Http\Response
     */
    public function destroy(OnlineVideoAttendance $onlineVideoAttendance)
    {
        //
    }
    
    public function detailedReport(Request $request)
    {
        if(isset($request->student_id)){
            $date=date_create(date('Y-m-d'));
            date_sub($date,date_interval_create_from_date_string("7 days"));
            $response['data']['7days'] = OnlineVideoAttendance::where('student_id', $request->student_id)->orderBy('created_at', 'desc')->whereDate('created_at', '>=', date_format($date,"Y-m-d"))->paginate(15);
            
            $date=date_create(date('Y-m-d'));
            date_sub($date,date_interval_create_from_date_string("30 days"));
            $response['data']['30days'] = OnlineVideoAttendance::where('student_id', $request->student_id)->orderBy('created_at', 'desc')->whereDate('created_at', '>=', date_format($date,"Y-m-d"))->paginate(15);
            $response['status'] = 200;
            return response()->json($response);
        } 
        else{
            $response['status'] = 202;
            $response['message'] = 'Student Details not found';
            return response()->json($response);
        }
    }
}