<?php

namespace App\Http\Controllers;

use App\Models\OnlineVideoAttendance;
use Illuminate\Http\Request;

use App\Http\Requests\StoreOnlineAttendanceRequest;
//use App\http\Requests\AcademicYear\UpdateRequest;

use Carbon\Carbon;

class OnlineVideoAttendanceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreOnlineAttendanceRequest $request) {
        $onlineVideoAttendance = new OnlineVideoAttendance;
        $onlineVideoAttendance->student_id = $request->student_id;
        $onlineVideoAttendance->video_id = $request->video_id;
        $onlineVideoAttendance->title = isset($request->title)?$request->title:'';
        $onlineVideoAttendance->description = isset($request->description)?$request->description:'';
        $onlineVideoAttendance->start_timestamp = $request->start_timestamp;
        $onlineVideoAttendance->year = $request->year;
        $onlineVideoAttendance->save();
        $response['ov_attendance_id'] = $onlineVideoAttendance->id;
        $response['status'] = 200;
        return response()->json($response);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\OnlineVideoAttendance  $onlineVideoAttendance
     * @return \Illuminate\Http\Response
     */
    public function show(OnlineVideoAttendance $onlineVideoAttendance)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\OnlineVideoAttendance  $onlineVideoAttendance
     * @return \Illuminate\Http\Response
     */
    public function edit(OnlineVideoAttendance $onlineVideoAttendance)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\OnlineVideoAttendance  $onlineVideoAttendance
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {
        $onlineVideoAttendance = OnlineVideoAttendance::find($id);
        $onlineVideoAttendance->end_timestamp = $request->end_timestamp;
        $startTime = Carbon::parse($onlineVideoAttendance->start_timestamp);

        $endTime = Carbon::parse($request->end_timestamp);

        $totalDurationHrs =  $startTime->floatDiffInHours($endTime);
        $totalDurationMins =  $startTime->floatDiffInMinutes($endTime);   
        $totalDurationSec =  $startTime->diffInSeconds($endTime);
        $onlineVideoAttendance->duration_hr  = $totalDurationHrs;
        $onlineVideoAttendance->duration_min  = $totalDurationMins;
        $onlineVideoAttendance->duration_sec  = $totalDurationSec;
        $onlineVideoAttendance->save();
        $response['status'] = 200;
        return response()->json($response);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\OnlineVideoAttendance  $onlineVideoAttendance
     * @return \Illuminate\Http\Response
     */
    public function destroy(OnlineVideoAttendance $onlineVideoAttendance)
    {
        //
    }
}