<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\OnlineVideoAttendanceController;
use App\Http\Controllers\OnlineVideoAttendanceReportController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::apiResource('video-attendances', OnlineVideoAttendanceController::class);
Route::apiResource('video-attendance-report', OnlineVideoAttendanceReportController::class);
Route::get('detailed-video-attendance-report', [OnlineVideoAttendanceReportController::class, 'detailedReport']);

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});
